# Kotlin Fundamentals: Design For Everyone

Bu Quiz Design For Everyone aşaması quizinin tam çevirisidir. Aşağıdaki soruları çözdüyseniz [bu linkten](https://developer.android.com/courses/quizzes/kotlin-fundamentals-ten/kotlin-fundamentals-ten?authuser=6&continue=https%3A%2F%2Fdeveloper.android.com%2Fcourses%2Fpathways%2Fkotlin-fundamentals-ten%3Fauthuser%3D6%23quiz-%2Fcourses%2Fquizzes%2Fkotlin-fundamentals-ten%2Fkotlin-fundamentals-ten)  cevapları gönderip başarı seviyenizi görebilir ve paylaşılabilir bir badge kazanabilirsiniz! Bu sınavı geçmek için en az 5 soruyu doğru cevaplamalısınız.

#### Q1. Temaları tanımlamak için hangi tag kullanılır?
- [ ] `<style>`
- [ ] `<theme>`
- [ ] `<meta-tag>`
- [ ] `<styling>`


#### Q2. Temalar ve stiller arasındaki fark nedir?
- [ ] Belirli görünümlere stiller uygulayabilirken, temalar uygulamanın tamamına uygulanır.
- [ ] Temalar diğer temalardan inherit(miras) alamaz, ancak stiller diğer stillerden inherit(miras) alabilir.
- [ ] Stiller diğer stillerden inherit(miras) alamaz, ancak temalar diğer temalardan inherit(miras) alabilir.
- [ ] Temalar Android sistemi tarafından sağlanırken stiller geliştirici tarafından tanımlanır.

#### Q3. 16sp textSize özniteliğine sahip bir TextView'iniz olduğunu varsayalım. Bu TextView ayrıca, textSize'ı 14sp'ye ayarlayan bir stile sahiptir. Ayrıca uygulamada textSize'ı 12sp'ye ayarlayan bir tema da var. Ekranda görüntülenecek olan TextView'in gerçek textSize değeri nedir?
- [ ] `<12sp>`
- [ ] `<14sp>`
- [ ] `<16sp>`
- [ ] `<20sp>`

#### Q4. floating action button (FAB) ile ilgili aşağıdakilerden hangisi doğrudur?
- [ ] FAB genellikle kullanıcının ekranda gerçekleştirebileceği birincil eylemle ilişkilendirilir.
- [ ] FAB, ekranın kenarından 16 dp sağ alt köşeye yerleştirilmelidir.
- [ ] FAB, kendi görünüm modeli kodunuzu yazmanıza gerek kalmaması için özel bir tıklama işleyicisi kullanır.
- [ ] FAB, Materyal Tasarımı ilkelerini uygulayan uygulamalar için zorunlu bir unsurdur.

#### Q5. Aşağıdakilerden hangisi Material Design component'ları kullanmanın sebeplerinden biridir? (*Uygun gördüğünüz kadar çok cevap seçin.*)

- [ ] Güzel, işlevsel ve birlikte çalışacak şekilde tasarlanmıştır.
- [ ] Tutarlı stil kullanan bir uygulama oluşturmanıza yardımcı olurlar.
- [ ] Uygulamanızı tüm kullanıcılar için daha erişilebilir hale getirmenize yardımcı olurlar.
- [ ] Kötü bir renk şeması kullanıyorsanız Android Studio size bir uyarı verecektir.

#### Q6. Aşağıdakilerden hangisi boyutları tanımlamanın ve kullanmanın sebeplerinden biridir? (*Uygun gördüğünüz kadar çok cevap seçin.*)
- [ ] Uygulama genelinde aynı ölçümleri uygulamayı kolaylaştırır.
- [ ] Ölçümlere anlamlı semantik isimler vermenizi sağlar.
- [ ] Uygulamanız genelinde ölçümleri değiştirmeyi kolaylaştırır.
- [ ] Material Design'ı kullanmak için boyutlar gereklidir.

#### Q7. RTL dillerini desteklemek için aşağıdakilerden hangisi zorunludur?
- [ ] Bir RTL dil klavyesine geçin
- [ ] Tüm simgelerin Android:autoMirrored="true" kullandığından emin olun
- [ ] margins, padding ve layout properties'de Sol ve Sağ'ı Başlangıç ve Bitiş ile değiştirin
- [ ] İçerik açıklamaları sağlayın

#### Q8. Aşağıdaki erişilebilirlik araçlarından hangileri Android cihazlarda kullanılabilir? (*Uygun gördüğünüz kadar çok cevap seçin.*)
- [ ] TalkBack
- [ ] Accessibility Scanner
- [ ] Android Studio'da, Refactor > Mümkünse RTL desteği ekle
- [ ] Lint

#### Q9. Hangi temadan inherit almak, size karanlık ve aydınlık modlar için varsayılan stili verir?
- [ ] Theme.MaterialComponents.DayNight
- [ ] Theme.DarkTheme
- [ ] Theme.MaterialComponents.DarkAndLightTheme
- [ ] Theme.AppCompat.Light

#### Q10. Live region nedir?
- [ ] Kullanıcı için önemli olan ve değiştiğinde kullanıcıya bildirilmesi gereken bilgileri içeren bir düğüm
- [ ] Material Design yönergelerine göre şekil değiştiren ekranın bir bölgesi
- [ ] Video akışına izin veren bir görünüm
- [ ] Animasyonlu çizilebilir



